/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.aop;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.fxiaoke.erpdss.dbproxy.exception.CommonException;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result<Void> commonExceptionHandler(HttpServletResponse response, Exception e) {
        CommonException commonException = (CommonException)ExceptionUtil.getCausedBy((Throwable)e, (Class[])new Class[]{CommonException.class});
        if (commonException != null) {
            String msg = commonException.getMessage();
            if (msg == null) {
                msg = ExceptionUtil.getRootCauseMessage((Throwable)commonException);
            }
            return Result.newError((String)commonException.getErrorCode(), (String)msg);
        }
        return Result.newError((String)e.getMessage());
    }
}

