/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.aop;

import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAop {
    private static final Logger log = LoggerFactory.getLogger(LogAop.class);

    @Around(value="execution(* com.fxiaoke.erpdss.dbproxy.executor.*.*(..))||execution(* com.fxiaoke.erpdss.dbproxy.controller..*.*(..))||execution(* com.fxiaoke.erpdss.dbproxy.service.impl.*.*(..))||execution(* com.fxiaoke.erpdss.dbproxy.manager.*.*(..))||execution(* com.fxiaoke.erpdss.dbproxy.dao.*.*(..))")
    public Object interceptor(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        String fullClassName = point.getTarget().getClass().getName();
        String methodName = point.getSignature().getName();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            result = point.proceed();
            stopWatch.stop();
            log.info(" AOP trace {}.{},totalTime:{}ms arg{}, result:{}", new Object[]{fullClassName, methodName, stopWatch.getTime(), point.getArgs(), result});
        }
        catch (Exception e) {
            stopWatch.stop();
            if (fullClassName.contains("controller")) {
                log.error(" classname:{},,totalTime:{}ms, methedName:{}, args:{}, result:{},exception", new Object[]{fullClassName, stopWatch.getTime(), methodName, point.getArgs(), result, e});
            } else {
                log.error(" classname:{}, ,totalTime:{}ms,methedName:{}, args:{}, result:{},exception,{}", new Object[]{fullClassName, stopWatch.getTime(), methodName, point.getArgs(), result, e.getMessage()});
            }
            throw e;
        }
        return result;
    }
}

