/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.config;

import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.DataSourceWrapper;
import cn.hutool.db.ds.druid.DruidDSFactory;
import cn.hutool.setting.Setting;
import com.fxiaoke.erpdss.dbproxy.config.DynamicDataSource;
import com.fxiaoke.erpdss.dbproxy.config.SettingManager;
import com.fxiaoke.erpdss.dbproxy.exception.ServiceStartException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    @Autowired
    private SettingManager settingManager;

    @Bean
    @Primary
    public DynamicDataSource dynamicDataSource() {
        Setting setting = this.settingManager.getDbSetting();
        List groups = setting.getGroups();
        if (groups.isEmpty()) {
            throw new ServiceStartException("\u9700\u8981\u914d\u7f6edb.setting");
        }
        this.configGlobalDbConfig(setting);
        DSFactory.setCurrentDSFactory((DSFactory)new DruidDSFactory(setting));
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        for (String group : groups) {
            DataSourceWrapper datasource = (DataSourceWrapper)DSFactory.get((String)group);
            Setting groupSetting = setting.getSetting(group);
            dynamicDataSource.addOrUpdateDataSource(group, datasource, groupSetting);
        }
        return dynamicDataSource;
    }

    private void configGlobalDbConfig(Setting setting) {
        GlobalDbConfig.setCaseInsensitive((boolean)setting.getBool((Object)"caseInsensitive", Boolean.valueOf(false)));
    }
}

