/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import cn.hutool.setting.SettingUtil;
import com.fxiaoke.erpdss.dbproxy.config.EnvProp;
import com.fxiaoke.erpdss.dbproxy.exception.ServiceStartException;
import com.fxiaoke.erpdss.dbproxy.model.UserSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SettingManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SettingManager.class);
    @Value(value="${setting.dir:#{null}}")
    private String baseDirByProp;
    private String baseDir;
    private UserSetting userSetting;

    public void afterPropertiesSet() {
        String workingDir = System.getProperty("user.dir");
        log.debug("workingDir: {}", (Object)workingDir);
        this.baseDir = StrUtil.isEmpty((CharSequence)this.baseDirByProp) ? workingDir + FileUtil.FILE_SEPARATOR + "setting" : this.baseDirByProp;
        log.debug("baseDir: {}", (Object)this.baseDir);
        Setting dbSetting = this.getDbSetting();
        if (dbSetting.isEmpty()) {
            throw new ServiceStartException("need set db.setting in " + this.baseDir);
        }
        this.autoLoadUserSetting();
        this.autoLoadEnvSetting();
    }

    private void autoLoadUserSetting() {
        Setting settingFile = SettingUtil.get((String)(this.baseDir + FileUtil.FILE_SEPARATOR + "user.setting"));
        if (settingFile.isEmpty()) {
            throw new ServiceStartException("need set user.setting in " + this.baseDir);
        }
        this.loadUserSetting(settingFile);
        settingFile.autoLoad(true, b -> {
            if (b.booleanValue()) {
                this.loadUserSetting(settingFile);
            }
            log.info("reload user setting {},new:{}", b, (Object)settingFile);
        });
    }

    private void loadUserSetting(Setting settingFile) {
        String username = settingFile.getStr((Object)"username");
        String password = settingFile.getStr((Object)"password");
        if (StrUtil.isBlank((CharSequence)username) || StrUtil.isBlank((CharSequence)password)) {
            log.error("not set username or password");
        }
        this.userSetting = new UserSetting(username, password);
    }

    private void autoLoadEnvSetting() {
        Setting envSetting = SettingUtil.get((String)(this.baseDir + FileUtil.FILE_SEPARATOR + "env.setting"));
        if (envSetting.isEmpty()) {
            EnvProp.reloadBySetting((Setting)envSetting);
            envSetting.store();
        }
        envSetting.autoLoad(true, b -> {
            if (b.booleanValue()) {
                EnvProp.reloadBySetting((Setting)envSetting);
            }
            log.info("reload env {},new:{}", b, (Object)envSetting);
        });
    }

    public Setting getDbSetting() {
        Setting setting = SettingUtil.get((String)(this.baseDir + FileUtil.FILE_SEPARATOR + "db.setting"));
        if (!setting.isEmpty()) {
            setting.getGroupedMap().forEach((k, v) -> v.putIfAbsent("maxWait", "10000"));
        }
        return setting;
    }

    public UserSetting getUserSetting() {
        return this.userSetting;
    }
}

