/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.controller.api;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.stp.StpUtil;
import com.fxiaoke.erpdss.dbproxy.config.SettingManager;
import com.fxiaoke.erpdss.dbproxy.constant.ResultEnum;
import com.fxiaoke.erpdss.dbproxy.exception.LoginFailedException;
import com.fxiaoke.erpdss.dbproxy.model.DssDataDto;
import com.fxiaoke.erpdss.dbproxy.model.UserSetting;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryBySqlArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryByTimeFilterArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.SaveSqlArg;
import com.fxiaoke.erpdss.dbproxy.model.result.InsertDataResult;
import com.fxiaoke.erpdss.dbproxy.model.result.ListResult;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.model.result.UpdateDataResult;
import com.fxiaoke.erpdss.dbproxy.service.AdaptProxyService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dbadapt/proxy/api"})
public class AdaptProxyController {
    private static final Logger log = LoggerFactory.getLogger(AdaptProxyController.class);
    @Autowired
    private AdaptProxyService adaptProxyService;
    @Autowired
    private SettingManager settingManager;

    @RequestMapping(value={"login"})
    @SaIgnore
    public Result<String> login(String username, String password) {
        UserSetting userSetting = this.settingManager.getUserSetting();
        if (userSetting.match(username, password)) {
            StpUtil.login((Object)-10000);
            return Result.newSuccess();
        }
        SaHolder.getResponse().setStatus(401);
        throw new LoginFailedException();
    }

    @PostMapping(value={"/create"})
    public Result<InsertDataResult> insertData(@RequestBody SaveSqlArg requestArg) {
        Result result = new Result();
        String oldName = Thread.currentThread().getName();
        try {
            InsertDataResult insertDataResult = this.adaptProxyService.insertData(requestArg);
            result.setData((Object)insertDataResult);
        }
        catch (Exception e) {
            result.setErrCode(ResultEnum.SYSTEM_ERROR.getErrorCode());
            result.setErrMsg(e.getMessage());
            log.error("\u65b0\u589e\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
        Thread.currentThread().setName(oldName);
        return result;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    @ResponseBody
    public Result<UpdateDataResult> updateData(@RequestBody SaveSqlArg requestArg) {
        Result result = new Result();
        String oldName = Thread.currentThread().getName();
        try {
            UpdateDataResult updateDataResult = this.adaptProxyService.updateData(requestArg);
            result.setData((Object)updateDataResult);
        }
        catch (Exception e) {
            result.setErrCode(ResultEnum.SYSTEM_ERROR.getErrorCode());
            result.setErrMsg(e.getMessage());
            log.error("\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
        Thread.currentThread().setName(oldName);
        return result;
    }

    @RequestMapping(value={"/queryMasterBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    @ResponseBody
    public Result<ListResult<DssDataDto>> queryData(@RequestBody QueryByTimeFilterArg requestArg) {
        Result result = new Result();
        String oldName = Thread.currentThread().getName();
        try {
            List datas = this.adaptProxyService.queryMasterBatch(requestArg);
            ListResult listResult = new ListResult().setTotalNum(datas.size()).setDataList(datas);
            result.setData((Object)listResult);
        }
        catch (Exception e) {
            result.setErrCode(ResultEnum.SYSTEM_ERROR.getErrorCode());
            result.setErrMsg(e.getMessage());
            log.error("\u67e5\u8be2\u5217\u8868\u5931\u8d25\uff1a", (Throwable)e);
        }
        Thread.currentThread().setName(oldName);
        return result;
    }

    @RequestMapping(value={"/queryMasterById"})
    @ResponseBody
    public Result<DssDataDto> getData(@RequestBody QueryBySqlArg requestArg) {
        Result result = new Result();
        String oldName = Thread.currentThread().getName();
        try {
            DssDataDto data = this.adaptProxyService.queryMasterById(requestArg);
            result.setData((Object)data);
        }
        catch (Exception e) {
            result.setErrCode(ResultEnum.SYSTEM_ERROR.getErrorCode());
            result.setErrMsg(e.getMessage());
            log.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
        Thread.currentThread().setName(oldName);
        return result;
    }
}

