/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.executor;

import cn.hutool.db.Db;
import com.fxiaoke.erpdss.dbproxy.constant.ExecuteType;
import com.fxiaoke.erpdss.dbproxy.exception.ExecutorException;
import com.fxiaoke.erpdss.dbproxy.executor.ApiExecutor;
import com.fxiaoke.erpdss.dbproxy.executor.db.DbExecutor;
import com.fxiaoke.erpdss.dbproxy.model.execute.ExecuteArg;
import com.fxiaoke.erpdss.dbproxy.model.execute.ExecuteResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutorManager {
    private final Map<ExecuteType, DbExecutor<?, ?>> dbExecutorMap = new HashMap();

    @Autowired
    public void putExecutors(List<ApiExecutor<?>> executors) {
        for (ApiExecutor<?> executor : executors) {
            if (!(executor instanceof DbExecutor)) continue;
            this.dbExecutorMap.put(executor.getExecuteType(), (DbExecutor)executor);
        }
    }

    public ExecuteResult executeDb(ExecuteArg arg, Db db) {
        DbExecutor executor = (DbExecutor)this.dbExecutorMap.get(arg.getExecuteType());
        if (executor == null) {
            throw new ExecutorException("\u672a\u627e\u5230\u6267\u884c\u5668 " + arg.getExecuteType());
        }
        Object result = executor.executeWithDb(db, arg.getBody());
        ExecuteResult executeResult = new ExecuteResult().setReferenceId(arg.getReferenceId()).setBody(result);
        return executeResult;
    }
}

