/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.lang.func.VoidFunc1;
import cn.hutool.db.Db;
import com.fxiaoke.erpdss.dbproxy.config.DynamicDataSource;
import com.fxiaoke.erpdss.dbproxy.exception.ExecutorException;
import com.fxiaoke.erpdss.dbproxy.executor.ExecutorManager;
import com.fxiaoke.erpdss.dbproxy.model.execute.BeanPathPair;
import com.fxiaoke.erpdss.dbproxy.model.execute.CompositeExecuteArg;
import com.fxiaoke.erpdss.dbproxy.model.execute.CompositeExecuteResult;
import com.fxiaoke.erpdss.dbproxy.model.execute.ExecuteArg;
import com.fxiaoke.erpdss.dbproxy.model.execute.ExecuteResult;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiExecuteServiceImpl {
    private static final Logger log = Logger.getLogger(ApiExecuteServiceImpl.class.getName());
    @Autowired
    private ExecutorManager executorManager;
    @Autowired
    private DynamicDataSource dataSource;

    public Result<CompositeExecuteResult> compositeExecute(CompositeExecuteArg compositeArg) {
        Db db = this.dataSource.getCurrentDb();
        CompositeExecuteResult result = new CompositeExecuteResult();
        this.checkArgs(compositeArg);
        Dict referencableObj = new Dict();
        if (compositeArg.isTx()) {
            try {
                db.tx((VoidFunc1 & Serializable)v -> this.compositeExecute2(compositeArg, referencableObj, v, result));
            }
            catch (SQLException e) {
                throw new ExecutorException((Throwable)e);
            }
        } else {
            this.compositeExecute2(compositeArg, referencableObj, db, result);
        }
        return Result.newSuccess((Object)result);
    }

    private void compositeExecute2(CompositeExecuteArg arg, Dict referencableObj, Db db, CompositeExecuteResult result) {
        for (ExecuteArg executeArg : arg.getArgs()) {
            Dict body = executeArg.getBody();
            List referenceRelationMap = executeArg.parseReferenceRelationMap();
            for (BeanPathPair beanPathPair : referenceRelationMap) {
                Object value = beanPathPair.getSourcePath().get((Object)referencableObj);
                beanPathPair.getDestPath().set((Object)body, value);
            }
            ExecuteResult singleResult = this.executorManager.executeDb(executeArg, db);
            result.add((Object)singleResult);
            referencableObj.put(singleResult.getReferenceId(), singleResult.getBody());
        }
    }

    public Result<ExecuteResult> execute(ExecuteArg arg, Db db) {
        if (db == null) {
            db = this.dataSource.getCurrentDb();
        }
        ExecuteResult execute = this.executorManager.executeDb(arg, db);
        return Result.newSuccess((Object)execute);
    }

    private void checkArgs(CompositeExecuteArg arg) {
        LinkedHashSet<String> referencable = new LinkedHashSet<String>();
        for (ExecuteArg executeArg : arg.getArgs()) {
            List pairList = executeArg.parseReferenceRelationMap();
            LinkedHashSet referenceIds = pairList.stream().map(pair -> {
                String referenceId = (String)pair.getSourcePath().getPatternParts().get(0);
                return referenceId;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            Collection referenceNotfound = CollUtil.subtract((Collection)referenceIds, referencable);
            if (!referenceNotfound.isEmpty()) {
                throw new ExecutorException("\u4ee5\u4e0b\u5f15\u7528\u987a\u5e8f\u4e0d\u6b63\u786e\uff0c\u6216\u65e0\u6cd5\u627e\u5230\u5f15\u7528\u5bf9\u8c61\u3002" + referenceNotfound);
            }
            if (referencable.add(executeArg.getReferenceId())) continue;
            throw new ExecutorException("referenceId\u91cd\u590d\uff1a" + executeArg.getReferenceId());
        }
        log.info("checkArgs: " + referencable);
    }
}

