# 安装JDK
## 要求
Java 版本需大于等于8 ，经测试的版本是Jdk8 和 Jdk21

## 在线安装（需要联网）
### Debian/Ubuntu
打开终端，使用下面的命令来安装OpenJDK 8：

```bash
sudo apt update
sudo apt install openjdk-8-jdk -y
```

### CentOS/RHEL
对于CentOS或RHEL，你可以使用以下命令安装：

```bash
sudo yum update
sudo yum install java-1.8.0-openjdk-devel -y
```
### windows
可以直接上openjdk发行版官网下载安装
https://adoptium.net/zh-CN/

### 验证安装
安装完成后，你可以运行以下命令来验证Java版本：

```bash
java -version
```

## 离线安装

### 1. Windows 系统离线安装 JDK

#### 步骤 1：下载 JDK
1. 从 Oracle 官网（或其他可信的 Java 发行版本网站，如 AdoptOpenJDK）下载适用于 Windows 的 JDK 安装包（.exe 文件）。
   - adoptium: https://adoptium.net/zh-CN/ 
   - 清华镜像站：https://mirrors.tuna.tsinghua.edu.cn/Adoptium/
2. 选择适合你的系统架构（32位或64位）的版本。不知道的选32位就行

#### 步骤 2：安装 JDK
1. 将下载的 .exe 文件传输到目标 Windows 机器。
2. 双击 .exe 文件开始安装。
3. 按照安装向导的指示操作，选择安装路径等。
4. 完成安装后，可能需要手动设置环境变量：
    - 右键点击“我的电脑”或“此电脑”，选择“属性”。
    - 点击“高级系统设置” -> “环境变量”。
    - 在“系统变量”区域，找到并选择“Path”变量，点击“编辑”。
    - 在变量值的末尾添加 JDK 的安装路径下的 bin 目录，例如：`;C:\Program Files\Java\jdk-xx\bin`。
    - 确认保存。

#### 步骤 3：验证安装
1. 打开终端或命令提示符（CMD）。
2. 输入 `java -version` 和 `javac -version` 检查 Java 是否正确安装和配置。

### 2. Linux 系统离线安装 JDK（以Ubuntu为例）
在Ubuntu系统中进行JDK的离线安装，您需要先下载JDK的压缩包到您的机器上，然后进行解压和配置。以下是一般步骤：

1. **下载JDK**
   - Oracle官网：https://www.oracle.com/java/technologies/javase-downloads.html
   - adoptium: https://adoptium.net/zh-CN/
   - 清华镜像站：https://mirrors.tuna.tsinghua.edu.cn/Adoptium/

2. **将JDK压缩包传输到您的Ubuntu系统**
   - 如果您已在另一台机器上下载了JDK压缩包，可以使用USB驱动器或通过网络传输到目标Ubuntu系统。

3. **解压JDK压缩包**
   - 将压缩包放置到您想要解压的目录，比如 `/usr/lib/jvm`

   ```bash
   sudo mkdir -p /usr/lib/jvm
   cd /usr/lib/jvm
   sudo tar -xvzf /path/to/your-jdk-file.tar.gz
   ```

   将`/path/to/your-jdk-file.tar.gz`替换为您的JDK压缩文件的实际路径。

4. **配置环境变量**
   - 为了让系统识别JDK，您需要设置环境变量。

   ```bash
   sudo update-alternatives --install "/usr/bin/java" "java" "/usr/lib/jvm/jdk-version/bin/java" 1
   sudo update-alternatives --install "/usr/bin/javac" "javac" "/usr/lib/jvm/jdk-version/bin/javac" 1
   ```

   替换`jdk-version`为您实际解压的JDK目录名称。

   - 设置JAVA_HOME环境变量，编辑`/etc/profile`或者用户的`~/.bashrc`文件：vim或者nano编辑后，在后面添加即可

   ```bash
   export JAVA_HOME=/usr/lib/jvm/jdk-version
   export PATH=$PATH:$JAVA_HOME/bin
   ```

   同样替换`jdk-version`为您实际的JDK目录名称。

5. **更新环境变量**
   - 使环境变量生效：

   ```bash
   source /etc/profile  # 如果您编辑的是/etc/profile
   或者
   source ~/.bashrc      # 如果您编辑的是~/.bashrc
   ```

6. **验证安装**
   - 检查Java版本以确认安装成功：

   ```bash
   java -version
   javac -version
   ```