/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.config;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.druid.support.http.StatViewFilter;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import com.fxiaoke.erpdss.dbproxy.config.WebMvcConfig;
import com.fxiaoke.erpdss.dbproxy.constant.ResultEnum;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.utils.JacksonUtil;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new DsInterceptor()).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public FilterRegistrationBean druidStatViewFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        StatViewFilter statViewFilter = new StatViewFilter();
        registration.setFilter((Filter)statViewFilter);
        registration.addUrlPatterns(new String[]{"/druid/*"});
        registration.setName("DruidStatViewFilter");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean druidWebStatFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        WebStatFilter webStatFilter = new WebStatFilter();
        registration.setFilter((Filter)webStatFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("DruidWebStatFilter");
        registration.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return registration;
    }

    @Bean
    public DruidStatInterceptor druidStatInterceptor() {
        return new DruidStatInterceptor();
    }

    @Bean
    public SaServletFilter getSaServletFilter() {
        SaServletFilter saServletFilter = new SaServletFilter().addInclude(new String[]{"/**"}).addExclude(new String[]{"/favicon.ico", "/dbadapt/proxy/api/getServiceInfo", "/dbadapt/proxy/api/test", "/test", "/hello"}).setAuth(obj -> {
            SaRouter.match((String[])new String[]{"/admin/**", "/druid/**"}).check(r -> {
                if (!StpUtil.isLogin()) {
                    SaHolder.getRequest().forward("/admin/login");
                    SaRouter.back();
                }
            });
            SaRouter.match((String)"/**", (String)"/dbadapt/proxy/api/login", () -> StpUtil.checkLogin());
        }).setError(e -> {
            SaHolder.getResponse().setStatus(401);
            SaHolder.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
            Result errorResult = Result.newError((String)ResultEnum.SYSTEM_LOGIN_ERROR.getErrorCode(), (String)(ResultEnum.SYSTEM_LOGIN_ERROR.getErrorMessage() + ":" + e.getMessage()));
            return JacksonUtil.obj2String((Object)errorResult);
        });
        return saServletFilter;
    }
}

