/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.executor.db;

import cn.hutool.core.lang.Dict;
import cn.hutool.db.Db;
import com.fxiaoke.erpdss.dbproxy.constant.ExecuteType;
import com.fxiaoke.erpdss.dbproxy.exception.ExecutorException;
import com.fxiaoke.erpdss.dbproxy.executor.ApiExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbExecutor<T, R>
extends ApiExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(DbExecutor.class);

    protected DbExecutor(ExecuteType executeType) {
        super(executeType);
    }

    protected abstract R executeConverted(Db var1, T var2) throws Exception;

    public R executeWithDb(Db db, Dict parameters) {
        Object object;
        Object r = null;
        long start = System.currentTimeMillis();
        try {
            Object convertedParameters = this.convertParameters(parameters);
            object = r = this.executeConverted(db, convertedParameters);
        }
        catch (Exception e) {
            try {
                long cost = System.currentTimeMillis() - start;
                log.error("executeWithDb end exception,cost:{},params:{}", new Object[]{cost, parameters, e});
                throw ExecutorException.wrap((Exception)e);
            }
            catch (Throwable throwable) {
                long cost = System.currentTimeMillis() - start;
                log.info("executeWithDb end,cost:{},params:{},result:{}", new Object[]{cost, parameters, r});
                throw throwable;
            }
        }
        long cost = System.currentTimeMillis() - start;
        log.info("executeWithDb end,cost:{},params:{},result:{}", new Object[]{cost, parameters, r});
        return (R)object;
    }
}

