# 部署说明
## 安装Jdk
参考：[安装JDK.md](安装JDK.md)

## 配置文件
服务有两种配置。
第一种是spring的配置。
默认启用spring的prod环境，所以可以在jar包同级目录创建`application-prod.yml`增加配置。
示例：

```yaml
# application-prod.yml
setting:
  # 设置文件目录 可以使用相对路径,不配置时，默认使用工作目录下的setting文件夹
  dir: D:\project\DBMidProxyServer\setting
server:
  servlet:
    # 服务路径，默认不设置是/
    context-path: /
```

另外一种是使用hutool的配置。其中user.setting代码已经支持了动态加载。
db.setting未支持。
以上setting.dir指定的目录下必须包含两个配置文件`db.setting`和`user.setting`

```
#db.setting 数据库配置，
#使用druid的配置参考https://github.com/alibaba/druid/wiki/DruidDataSource%E9%85%8D%E7%BD%AE%E5%B1%9E%E6%80%A7%E5%88%97%E8%A1%A8
#分组名就是作为数据源名称
[db1]
url=jdbc:postgresql://localhost:5432/db1?ssl=false
username=postgres
password=1234qwer
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
[db2]
url=jdbc:postgresql://localhost:5432/db2?ssl=false
username=postgres
password=1234qwer
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
[db3]
# mysql
url=jdbc:mysql://localhost:3306/db3?useSSL=false&characterEncoding=UTF-8&connectionTimeZone=Asia/Shanghai
username=root
password=1234qwer
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
[db4]
# sqlserver
url=jdbc:sqlserver://;serverName=localhost;databaseName=db4;encrypt=true;trustServerCertificate=true
username=sa
password=8kn0ye66JxO5
# 如果需要支持SqlServer2008的offset分页，设置isSqlServer2008=true
#isSqlServer2008=true
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
[db5]
# oracle
url=jdbc:oracle:thin:@127.0.0.1:1521:XE
username=dbproxy
password=1234qwer
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
[dm8]
# 达梦数据库 需要另外增加驱动启动
url=jdbc:dm://localhost:5236?LobMode=1
username=SYSDBA
password=SYSDBA001
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
# 未集成驱动的，需要指定jdbc驱动的jar包。
driverJarPath=D:\driver\db-driver\DmJdbcDriver18.jar
[access]
# access数据库在配置对象apiName中,需要注意选择不使用offset查询方式,查询日期格式为'CDate('''yyyy/MM/dd HH:mm:ss'')
url=jdbc:ucanaccess://d://test.accdb
queryTimeout=30
initialSize=5
maxActive=20
testWhileIdle=true
# 指定jdbc驱动类
driverClassName=net.ucanaccess.jdbc.UcanaccessDriver
```

```
# user.setting
# 安全性配置
username=admin
password=1234qwer
```

## 作为服务运行
### 创建配置文件
按上一章节，创建好配置文件

### windows
包内包含了db-proxy.exe和db-proxy.xml
1. 复制windows目录的所有文件到jar包目录。
2. 在jar包目录，打开终端。按需执行以下命令
```shell
# 安装服务
.\db-proxy.exe install
# 启动服务
.\db-proxy.exe start
# 重启服务
.\db-proxy.exe restart
# 查看服务状态
.\db-proxy.exe status
# 停止服务
.\db-proxy.exe stop
# 卸载服务
.\db-proxy.exe uninstall
```
### linux
使用Systemd.
1. 复制linux目录的cli脚本到jar包目录
2. 使cli脚本可执行
3. 执行cli
```shell
# 复制文件
cp ./linux/run.sh ./
# 使cli脚本可执行
chmod +x run.sh
# 启动cli，创建或更新服务
sudo ./run.sh

# 重启服务
systemctl restart db-proxy-server
# 停止服务
systemctl stop db-proxy-server
# 移除服务
systemctl disable db-proxy-server
```

也可以自行创建systemd配置文件，然后试用systemctl启用服务。
文件参考:
```
[Unit]
Description=Java Service - db-proxy-server
After=network.target network-online.target
Wants=network-online.target

[Service]
Type=simple
ExecStart=/usr/bin/java -jar {替换为jar路径}
WorkingDirectory={替换为jar所在目录}
User=root
Restart=on-failure
RestartSec=3
RestartSec=3

[Install]
WantedBy=multi-user.target
```

## 测试部署

部署成功后，在代理服务器上，可以访问以下链接测试。从内网机器，将localhost更换为代理服务的ip，公网则更换相应公网ip或域名。
API路径（用于连接配置）：http://localhost:8080/dbadapt/proxy/api
测试路径：http://localhost:8080/test; http://localhost:8080/dbadapt/proxy/api/test
后台管理路径：http://localhost:8080/admin

